/* **********************************************************
 * Copyright 2004 VMware, Inc.  All rights reserved.
 * **********************************************************/

/* 
 * os.h --
 *
 *      Definitions for OS-specific wrapper functions required
 *      by "vmdesched".  This allows customers to build their own
 *      vmdesched driver for custom versioned kernels without the
 *      need for source code. 
 */

#ifndef _OS_H
#define _OS_H

#define CDECL __attribute__((cdecl, regparm(0)))


/*
 * Types
 */

typedef void CDECL (*os_timer_callback)(void*);
typedef int  CDECL (*os_thread_function)(void*);
typedef int  CDECL (*os_simple_proc_read_callback)(char*);

typedef struct os_thread_data os_thread_data;



/*
 * Constants
 */

#define OS_MAX_CPUS (32)


/*
 * Functions
 */

extern void CDECL os_dequeue_signal_current(void);
extern void CDECL os_add_timer_callback(os_timer_callback callback,
					void *param);
extern void CDECL os_init_timer(void);
extern void CDECL os_del_timer_sync(void);

extern unsigned int CDECL os_smp_num_cpus(void);

extern void CDECL os_set_cpu_affinity_current(unsigned long cpuMask);
extern void CDECL os_set_highest_priority_current(void);
extern int  CDECL os_signal_pending_current(void);

extern void CDECL os_thread_interruptible_sleep(os_thread_data *threadData);
extern void CDECL os_thread_wake_up(os_thread_data *threadData);

extern void CDECL os_start_kernel_thread(os_thread_data *threadData,
					 os_thread_function func,
					 void *param);

extern void CDECL os_thread_stop(os_thread_data *threadData);
extern os_thread_data* CDECL os_init_thread_data_ptr(int id);

extern int CDECL os_sprintf(char *str, const char *format, ...);

extern void CDECL os_daemonize(char *name);

extern void CDECL os_create_simple_proc_read_node(char *procNodeName,
						  os_simple_proc_read_callback func);
extern void CDECL os_remove_simple_proc_node(char *procNodeName);



#endif  /* OS_H */
