%{?!python:         %define           python         python}
%{?!pybasever:      %{expand:%%define pybasever      %(%{__python} -c "import sys ; print sys.version[:3]")}}
%{!?python_sitelib: %define           python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

%{!?gstreamer:      %define           gstreamer      gstreamer}

Name:           pigment-python
Version:        0.3.6
Release:        1
Summary:        Python bindings for Pigment

Group:          Development/Languages
License:        LGPL
URL:            https://code.fluendo.com/pigment/trac
Source:         http://www.fluendo.com/elisa/downloads/pigment/%{name}-python-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Requires:       glib2 >= 2.8.0
Requires:       %{gstreamer} >= 0.10.0

BuildRequires:  glib2-devel >= 2.8.0
BuildRequires:  python-devel
BuildRequires:  pygobject2-devel
BuildRequires:  %{gstreamer}-devel >= 0.10.0
BuildRequires:  %{gstreamer}-plugins-base-devel >= 0.10.0
BuildRequires:  python-devel
# for gdk-pixbuf
BuildRequires:  gtk2-devel

%description
This module contains a wrapper that allows Pigment applications
to be written in Python.

%prep
%setup -q -n %{name}-%{version}

%build
%configure
make

%install
rm -rf $RPM_BUILD_ROOT

# Do not package .la files
%makeinstall
find $RPM_BUILD_ROOT%{_libdir} -name "*.la" -exec rm {} \;

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root, -)
%doc AUTHORS COPYING INSTALL NEWS README RELEASE TODO ChangeLog
%{python_sitelib}/*.so
%{python_sitelib}/pgm/*.pyc
%{python_sitelib}/pgm/graph/*.pyc
%{python_sitelib}/pgm/timing/*.pyc
%{python_sitelib}/pgm/utils/*.pyc
%{python_sitelib}/pgm/widgets/*.pyc

%changelog
* Fri Jan 11 2008 Loïc Molinari <loic@fluendo.com>
- first draft of spec file
